-- JOIN: ki veya daha fazla tablonun verilerini birletirerek tek bir tabloymu gibi sonu olarak getirmemizi salar.
-- Join sorgularnda bir tablonun primary key stunu ile dier tablodaki foreign key karl olan stun eitlenir.

-- 1) INNER JOIN: Birletirilen tablolarda sadece id'ler zerinden eleen kaytlar getirir.
-- Kullanm: select stunlar from tablo1 inner join tablo2 on tablo1.tablo2id = tablo2.id
-- Aadaki rnekte hem stun adlar hem de tablo adlar alias kullanlarak sorguda deitirilmitir.
-- rnein Film tablosu f olarak ksaltlmtr, f.id stunu ise Film ID olarak sorguda deitirilmitir.

use Filmler

-- Film ve Yonetmen tablolarn inner join ile birletirelim: * ile birletirilen tablolardaki tm stunlar dner.
-- Sorgu sonucunda 5 satr dner.
select *
from Film f inner join Yonetmen y on f.yonetmenId = y.Id

-- Film, Yonetmen ve Tur tablolarn inner join ile birletirelim:
-- Join sorgularndan sonra where kullanlarak kaytlar filtrelenebilir, order by ile de sralanabilir.
-- Tr Aksiyon, film giesi de 50000 ile 700000 arasnda olan kaytlar film yapm ylna gre artan sralayarak getir.
select f.Id as [Film ID], f.adi as [Film Ad], f.yapimyili as [Film Yapm Yl], f.gisesi as [Film Giesi],
y.Id as [Ynetmen ID], y.adi + ' ' + y.soyadi as [Ynetmen], y.dogumtarihi as [Ynetmen Doum Tarihi], t.adi as [Tr]
from Film f inner join Yonetmen y on f.yonetmenId = y.Id
inner join FilmTur ft on f.Id = ft.filmId
inner join Tur t on ft.turId = t.Id
where t.adi = 'Aksiyon' and f.gisesi >= 50000 and f.gisesi <= 700000
order by f.yapimyili

-- Inner join ile birletirilen Film, Yonetmen ve Tur tablolar zerinden film ad ve ynetmen ad ile soyadn birletirerek
-- getir ve oklayan satrlar teke dr.
select distinct f.adi as [Film], y.adi + ' ' + y.soyadi as [Ynetmen]
from Film f inner join Yonetmen y on f.yonetmenId = y.Id
inner join FilmTur ft on f.Id = ft.filmId
inner join Tur t on ft.turId = t.Id

-- 2) LEFT OUTER JOIN: Birletirilen tablolarda hem id'ler zerinden eleen kaytlar hem de tablolarn yazm srasna gre
-- soldaki tablonun tm kaytlar ile sadaki tabloda elemeyen karlklar null olacak ekilde getirir.
-- Kullanm: select stunlar from tablo1 left outer join tablo2 on tablo1.tablo2id = tablo2.id

-- Film, FilmDetay ve Yonetmen tablolarn left outer join ile birletirelim:
-- Aadaki sorgu sonucunda Avatar filminin ynetmen id'si null
-- olduu iin ynetmen tablosundan ekilen Ynetmen ID, Ynetmen ve Ynetmen Doum Tarihi verileri null gelecektir.
-- Dolaysyla join kullanlarak soldaki tablonun tm verileri getirilmek isteniyorsa
-- ve sadaki tabloda kaytlar elese de elemese de gelsin isteniyorsa left outer join kullanlmaldr.
-- Ayn durum FilmDetay tablosu iin de geerlidir.
-- Sorgu sonucunda 6 satr dner.
select f.Id as [Film ID], f.adi as [Film Ad], f.yapimyili as [Film Yapm Yl], f.gisesi as [Film Giesi],
fd.Maliyeti, fd.Aciklamasi as Aklamas,
y.Id as [Ynetmen ID], y.adi + ' ' + y.soyadi as [Ynetmen], y.dogumtarihi as [Ynetmen Doum Tarihi]
from Film f left outer join FilmDetay fd on f.Id = fd.FilmId left outer join Yonetmen y on f.yonetmenId = y.Id

-- Film, Yonetmen ve Tur tablolarn left outer join ile birletirelim:
-- Aadaki sorgu sonucunda Adalet Peinde filminin herhangi bir film tr kayd 
-- olmad iin tr tablosundan ekilen Tr verisi null olarak gelecektir,
-- Avatar filminin de ynetmen id'si null olduu iin ynetmen tablosundan ekilen 
-- Ynetmen ID, Ynetmen ve Ynetmen Doum Tarihi verileri null olarak gelecektir.
select f.Id as [Film ID], f.adi as [Film Ad], f.yapimyili as [Film Yapm Yl], f.gisesi as [Film Giesi],
y.Id as [Ynetmen ID], y.adi + ' ' + y.soyadi as [Ynetmen], y.dogumtarihi as [Ynetmen Doum Tarihi],
t.adi as [Tr]
from Film f left outer join Yonetmen y on f.yonetmenId = y.Id
left outer join FilmTur ft on f.Id = ft.filmId
left outer join Tur t on ft.turId = t.Id
order by f.adi -- film adna gre artan sralama

-- 3) RIGHT OUTER JOIN: Birletirilen tablolarda hem id'ler zerinden eleen kaytlar hem de tablolarn yazm srasna gre
-- sadaki tablonun tm kaytlar ile soldaki tabloda elemeyen karlklar null olacak ekilde getirir.
-- Kullanm: select stunlar from tablo1 right outer join tablo2 on tablo1.tablo2id = tablo2.id

-- Film, FilmDetay ve Yonetmen tablolarn right outer join ile birletirelim:
-- Aadaki sorgu sonucunda Avatar filminin ynetmen id'si null
-- olduu iin ynetmen tablosundan ekilen Ynetmen ID, Ynetmen ve Ynetmen Doum Tarihi verileri null gelecektir.
-- Dolaysyla join kullanlarak sadaki tablonun tm verileri getirilmek isteniyorsa
-- ve soldaki tabloda kaytlar elese de elemese de gelsin isteniyorsa right outer join kullanlmaldr.
-- Ayn durum FilmDetay tablosu iin de geerlidir.
-- Sorgu sonucunda 6 satr dner.
select f.Id as [Film ID], f.adi as [Film Ad], f.yapimyili as [Film Yapm Yl], f.gisesi as [Film Giesi],
fd.Maliyeti, fd.Aciklamasi as Aklamas,
y.Id as [Ynetmen ID], y.adi + ' ' + y.soyadi as [Ynetmen], y.dogumtarihi as [Ynetmen Doum Tarihi]
from Yonetmen y right outer join Film f on y.Id = f.yonetmenId right outer join FilmDetay fd on f.Id = fd.FilmId

-- Film, Yonetmen ve Tur tablolarn right outer join ile birletirelim:
-- Aadaki sorgu sonucunda Adalet Peinde filminin herhangi bir film tr kayd 
-- olmad iin tr tablosundan ekilen Tr verisi null olarak gelecektir.
select f.Id as [Film ID], f.adi as [Film Ad], f.yapimyili as [Film Yapm Yl], f.gisesi as [Film Giesi],
y.Id as [Ynetmen ID], y.adi + ' ' + y.soyadi as [Ynetmen], y.dogumtarihi as [Ynetmen Doum Tarihi],
t.adi as [Tr]
from Tur t right outer join FilmTur ft on t.Id = ft.turId
right outer join Film f on ft.filmId = f.Id
right outer join Yonetmen y on f.yonetmenId = y.Id
order by f.adi -- film adna gre artan sralama

-- Sorgulanmak istenen veriye gre bazen inner join, left outer join ve right outer join ayn sorguda kullanlabilir.